using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Reversi
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		Button[,] plansza=new Button[ReversiSilnik.planszaSzer,ReversiSilnik.planszaWys];
		ReversiSilnik silnik=new ReversiSilnik();

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//ustalanie rozmiaru przycisku
			int przyciskSzer=this.ClientSize.Width/ReversiSilnik.planszaSzer;
			int przyciskWys=this.ClientSize.Height/ReversiSilnik.planszaWys;

			//dopasowywanie okna do calkowitej ilosci przyciskow
			int roznicaSzer=(przyciskSzer*ReversiSilnik.planszaSzer-this.ClientSize.Width);
			int roznicaWys=(przyciskWys*ReversiSilnik.planszaWys-this.ClientSize.Height);
			this.Width+=roznicaSzer;
			this.Height+=roznicaWys;

			for (int i=0; i<ReversiSilnik.planszaSzer; i++)
				for (int j=0; j<ReversiSilnik.planszaWys; j++)
					{
					Button pole=new Button();
					pole.SetBounds(i*przyciskSzer,j*przyciskWys,przyciskSzer,przyciskWys);
					pole.Parent=this;
					pole.Click+=new System.EventHandler(this.kliknieciePolaPlanszy);
					plansza[i,j]=pole;
					}

			uzgodnijWygladPlanszy();

			/*
			//test
			silnik.UstawPionek(2,4);
			uzgodnijWygladPlanszy();
			*/
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(292, 267);
			this.Name = "WinForm";
			this.Text = "WinForm";
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		void uzgodnijWygladPlanszy()
		{
			for (int i=0; i<ReversiSilnik.planszaSzer; i++)
				for (int j=0; j<ReversiSilnik.planszaWys; j++)
					{
					//plansza[i,j].Text=silnik.plansza[i,j].ToString();
					switch(silnik.plansza[i,j])
						{
						case 0: plansza[i,j].BackColor=Color.Ivory; break;
						case 1: plansza[i,j].BackColor=Color.Green; break;
						case 2: plansza[i,j].BackColor=Color.Sienna; break;
						}
					}

			this.Text="Nastpny ruch gracz nr "+silnik.nrGraczaWykonujacegoNastepnyRuch;
		}

		void kliknieciePolaPlanszy(object sender,EventArgs e)
		{
			//szukamy odpowiedniego pola planszy
			int kliknietePoziomo=-1,kliknietePionowo=-1;
			for(int poziomo=0;poziomo<ReversiSilnik.planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<ReversiSilnik.planszaWys;pionowo++)
					if (sender==plansza[poziomo,pionowo])
						{
						kliknietePoziomo=poziomo;
						kliknietePionowo=pionowo;
						}

			//jezeli nie znaleziony - zglaszanie bledu
			if (kliknietePoziomo==-1 || kliknietePionowo==-1)
				throw new Exception("Nie zidentyfikowane pole planszy");

			//wykonanie ruchu
			silnik.UstawPionek(kliknietePoziomo,kliknietePionowo);
			uzgodnijWygladPlanszy();
		}
	}
}
